/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.parsing.ast;

import com.aptana.css.core.parsing.ast.CSSDeclarationNode;
import com.aptana.css.core.parsing.ast.CSSNode;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSMsViewPort
extends CSSNode {
    private static final String MS_VIEWPORT = "@-ms-viewport ";
    private static final CSSDeclarationNode[] NO_DECLARATIONS = new CSSDeclarationNode[0];
    private CSSDeclarationNode[] fDeclarations;

    public CSSMsViewPort(List<CSSDeclarationNode> declarations) {
        this.fDeclarations = declarations != null ? declarations.toArray(new CSSDeclarationNode[declarations.size()]) : NO_DECLARATIONS;
    }

    @Override
    public short getNodeType() {
        return 22;
    }

    public void addOffset(int offset) {
        super.addOffset(offset);
        CSSDeclarationNode[] cSSDeclarationNodeArray = this.fDeclarations;
        int n = this.fDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            CSSDeclarationNode node = cSSDeclarationNodeArray[n2];
            node.addOffset(offset);
            ++n2;
        }
    }

    public CSSDeclarationNode[] getDeclarations() {
        return this.fDeclarations;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(MS_VIEWPORT);
        text.append('{');
        CSSDeclarationNode[] declarations = this.getDeclarations();
        int i = 0;
        while (i < declarations.length) {
            text.append((Object)declarations[i]);
            if (i < declarations.length - 1) {
                text.append(' ');
            }
            ++i;
        }
        text.append('}');
        return text.toString();
    }
}

